import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/style.dart';
import '../../../../../core/utils/my_color.dart';

class GenericDropdown<T> extends StatefulWidget {
  final String? title;
  final T? selectedValue;
  final List<T>? list;
  final ValueChanged<T?>? onChanged;
  final double paddingLeft, paddingTop, paddingBottom;
  final double titleSpace;
  final double paddingRight;
  final double radius;
  final bool isShowTitle;
  final bool isShowArrow;
  final Color? bgColor;
  final Color? dropdownColor;
  final TextStyle? titleStyle;
  final TextStyle? hintTextStyle;
  final TextStyle? itemTextStyle;
  final Color? iconEnabledColor;
  final String Function(T) displayItem;

  const GenericDropdown({
    super.key,
    this.isShowTitle = true,
    this.titleSpace = 10,
    this.title,
    this.paddingLeft = 10,
    this.paddingRight = 10,
    this.paddingTop = 0,
    this.paddingBottom = 0,
    this.radius = Dimensions.space12,
    this.titleStyle,
    this.hintTextStyle,
    this.itemTextStyle,
    this.dropdownColor,
    this.selectedValue,
    this.list,
    this.bgColor,
    this.iconEnabledColor,
    this.onChanged,
    required this.displayItem,
    this.isShowArrow = true,
  });

  @override
  State<GenericDropdown<T>> createState() => _GenericDropdownState<T>();
}

class _GenericDropdownState<T> extends State<GenericDropdown<T>> {
  bool isExpanded = false;

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        if (widget.isShowTitle) Text((widget.title ?? "").tr, style: widget.titleStyle ?? regularDefault.copyWith(color: MyColor.colorBlack)),
        if (widget.isShowTitle) SizedBox(height: widget.titleSpace),
        AnimatedContainer(
          duration: const Duration(milliseconds: 300),
          decoration: BoxDecoration(color: widget.bgColor ?? MyColor.colorGrey1, border: Border.all(color: MyColor.borderColor, width: 1), borderRadius: BorderRadius.all(Radius.circular(widget.radius))),
          child: Padding(
            padding: EdgeInsets.only(
              left: widget.paddingLeft,
              right: widget.paddingRight,
              bottom: widget.paddingBottom,
              top: widget.paddingTop,
            ),
            child: DropdownButtonHideUnderline(
              child: DropdownButton<T>(
                isExpanded: true,
                menuMaxHeight: 300,
                alignment: Alignment.centerLeft,
                hint: Text(
                  (widget.selectedValue != null ? widget.displayItem(widget.selectedValue as T) : '').tr,
                  style: widget.hintTextStyle ?? boldDefault.copyWith(fontSize: 17, color: MyColor.colorWhite),
                ),
                value: widget.selectedValue ?? (widget.list?.isNotEmpty == true ? widget.list!.first : null),
                dropdownColor: widget.dropdownColor ?? MyColor.colorWhite,
                iconEnabledColor: widget.iconEnabledColor ?? MyColor.primaryColor,
                icon: widget.isShowArrow ? Icon(Icons.keyboard_arrow_down_rounded, color: MyColor.iconColor, size: 24) : SizedBox.shrink(),
                onChanged: (value) {
                  setState(() {
                    isExpanded = false;
                  });
                  widget.onChanged?.call(value);
                },
                items: widget.list?.map(
                  (value) {
                    return DropdownMenuItem<T>(
                      value: value,
                      child: Text(
                        widget.displayItem(value).tr,
                        style: widget.itemTextStyle ?? regularDefault.copyWith(fontSize: 17, color: MyColor.bodyTextColor),
                      ),
                    );
                  },
                ).toList(),
                onTap: () {
                  setState(() {
                    isExpanded = !isExpanded;
                  });
                },
              ),
            ),
          ),
        ),
      ],
    );
  }
}
